/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.HashMap;
import java.util.TreeMap;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsMapContaining;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsMapContainingValueTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsMapContaining.hasValue((Object)"foo");
    }

    public void testHasReadableDescription() {
        IsMapContainingValueTest.assertDescription("map containing [ANYTHING->\"a\"]", IsMapContaining.hasValue((Object)"a"));
    }

    public void testDoesNotMatchEmptyMap() {
        HashMap map = new HashMap();
        IsMapContainingValueTest.assertMismatchDescription("map was []", IsMapContaining.hasValue((Object)1), map);
    }

    public void testMatchesSingletonMapContainingValue() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 1);
        IsMapContainingValueTest.assertMatches("Singleton map", IsMapContaining.hasValue((Object)1), map);
    }

    public void testMatchesMapContainingValue() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        map.put("c", 3);
        IsMapContainingValueTest.assertMatches("hasValue 1", IsMapContaining.hasValue((Object)1), map);
        IsMapContainingValueTest.assertMatches("hasValue 3", IsMapContaining.hasValue((Object)3), map);
        IsMapContainingValueTest.assertMismatchDescription("map was [<a=1>, <b=2>, <c=3>]", IsMapContaining.hasValue((Object)4), map);
    }
}

